/*
 * File:   ppmIn.h
  * 
 */

#ifndef _PPM_IN_
#define _PPM_IN_

#include <stdbool.h>

#define PPM_PORT PORTAbits.RA0		// Tx/Rx-Pin
#define PPM_TRIS TRISAbits.TRISA0
#define PPM_PIN  (0b00000001)       // (bitmask) pin must have IOC function!

#define PPMIOCF IOCAFbits.IOCAF0 
#define PPMIOCP IOCAPbits.IOCAP0 
#define PPMIOCN IOCANbits.IOCAN0 

typedef union {
	struct {
		unsigned ENABLE			:1;			// PPM processing activated
        unsigned LEVEL          :1;         // current pulse level
        unsigned TIMEOUT        :1;         // for detection of PPM activity
		unsigned NEWPULSE		:1;			// got a new pulse
        unsigned NEWCTRL        :1;         // New valid control value
	};
    uint8_t ppmCR;                          // complete control register
} ppmCRbits_t;

extern volatile ppmCRbits_t ppmCRbits;
extern volatile int16_t ppmPW;
extern int8_t inCtrl;


#define ppmCR ppmCRbits.ppmCR

void setupPPM (void);
bool processPPM (void);

#endif  // _PPM_IN_