/*
 * File:   motor.h
 * 
 */

#ifndef _MOTOR_H_
#define _MOTOR_H_

typedef union {
	struct {
		unsigned REVERSE		:1;			// actual direction = reverse
		unsigned OUTLVL			:1;			// curent output level (softpwm)
		unsigned                :1;			// 
		unsigned                :1;			// 
		unsigned LOCK_REV       :1;			// locked against reverse drive
		unsigned LOCK_FWD       :1;         // locked against forward drive
		unsigned SHORTDET       :1;			// shutdown by I exceeding absolute limit
	};
    uint8_t PWM_CTRLbyte;                   // complete control register
} PWM_CTRLbits_t;

extern volatile PWM_CTRLbits_t PWM_CTRLbits;

extern uint16_t break_tmr;
extern int8_t m_ctrl;
extern volatile uint24_t msCnt;
extern volatile uint16_t filt_I;

void PWMinit (void);
void SetMotor (int8_t ctrl);
void ReleaseBreak (void);
void checkCurrentTH(void);
uint24_t millis(void);

#endif  // _PWM_H_