/*
 * File:   SoftUART.h
 * Software-UART fr Debug-Zwecke
 * Author: Otti
  * 
 */

#ifndef _SOFTUART_
#define _SOFTUART_

#define BAUDRATE 9600		// UART baud rate 
#define UTXBUFSIZE 32		// size of UART Tx Buffer (must be an integer power of 2!)

#define UTMRCLK 1000000		// SW-UART TMR clock frequency (output of prescaler)
#define UART_PORT PORTAbits.RA0		// Tx/Rx-Pin
#define UART_LAT LATAbits.LATA0
#define UART_TRIS TRISAbits.TRISA0
#define UART_PIN  (0b00000001)   // (bitmask) pin must have IOC function!

#define UIOCF IOCAFbits.IOCAF0 
#define UIOCP IOCAPbits.IOCAP0 
#define UIOCN IOCANbits.IOCAN0 

typedef union {
	struct {
		unsigned RXBSY			:1;			// receiving
		unsigned TXBSY			:1;			// transmitting
		unsigned RXBF			:1;			// receiver buffer full (rx-data in uartDR)
		unsigned TXBF			:1;			// txbuffer contains data to send
		unsigned STARTBIT		:1;			// tx: just sent startbit 
		unsigned STOPBIT		:1;			// rx: expect stopbit, tx: just sent stopbit
		unsigned SAVGIE			:1;			// stores current state of GIE 
	};
    uint8_t uartCR;                         // complete control register
} uartCRbits_t;

extern volatile uartCRbits_t uartCRbits;
#define uartCR uartCRbits.uartCR

extern volatile uint8_t uartDR, uartShR;

extern void softUART_init(void);
extern void UartTxByte (uint8_t data);
extern void UartTxNow(void);

#define BITTIME (UTMRCLK/BAUDRATE)

#endif  // _SOFTUART_