/*
 * File:   blinky.c
 * Author: Otti
 *
 * Created on 22. Dezember 2015, 23:59
 */

#include <xc.h>
#include <stdint.h>
//_______________________________________________________________
// Pin Usage:
//
#define LED_PORT LATC
#define LED_TRIS TRISC
#define LED_PIN 3
#define BOOT_PORT PORTA
#define BOOT_ANSEL ANSELA
#define BOOT_PIN 0
#define BOOT_LEVEL 0
//_______________________________________________________________

#define BLINKTIME 500
volatile uint16_t mscnt = 0;
uint16_t tstamp = 0;

// Timer 0 ISR: (TMR0 is the only IRQ source here)
void interrupt timertick(void)
{
    TMR0IF=0;                   // clr IRQ
    TMR0 += 6;                  // adjust: next timout after 250 counts (->millisec.)
    mscnt++;                    // increment milliseconds
}

void main(void) {
    uint16_t temp;
  #ifdef BOOT_ANSEL
    BOOT_ANSEL &= ~(1<<BOOT_PIN);   // Bootpin = digital input
  #endif
    OSCCON = 0b01111000;        // clock = 16MHz
    OPTION_REG = 0b00000011;    // TMR0 clock = 250 kHz
    LED_TRIS &= ~(1<<LED_PIN);  // LED Port = output
    
    LED_PORT = 0;
    
    TMR0IE = 1;
    GIE = 1;
    
    while(1)
    {
#if BOOT_LEVEL == 0
        if((BOOT_PORT & 1<<BOOT_PIN) == 0)      // call bootloader if bootpin = low
            break;
#else
        if((BOOT_PORT & 1<<BOOT_PIN) != 0)      // call bootloader if bootpin = high
            break;
#endif
        di();                                   // read of mscnt = 16 bits is not atomic!
        temp = mscnt;                           
        ei();
        if (((temp -= tstamp) & 0x8000) == 0)
        {
            tstamp += BLINKTIME;            // set next periode time
            LED_PORT ^= 1<<LED_PIN;         // toggle LED
        }
    }
    
    di();
    FSR0H |= 0x80;                          // set MSB: bootloader called from app!
    asm("movlp 0\ngoto 0");                 // goto reset vector
    return;
}
