;************************************************************************
; Blinky Testprogram
;************************************************************************
;
; This code is written for the following PIC microcontrollers:
; Enhanced Midrange with bootloader
;_______________________________________________________________
#ifdef __16F1503	
	#include <p16F1503.inc> 
; Pin Usage (14-Pin package):
;
	#define LED_PORT PORTC
	#define LED_PIN 3
	#define BOOT_PORT PORTA
	#define NBOOT_PIN 0
#endif
;_______________________________________________________________
#ifdef __16F1705	
	#include <p16F1503.inc> 
; Pin Usage (14-Pin package):
;
	#define LED_PORT PORTC
	#define LED_PIN 3
	#define BOOT_PORT PORTA
	#define NBOOT_PIN 0
#endif
;_______________________________________________________________
#ifdef __12F1840	
	#include <p12F1840.inc> 
; Pin Usage (8-Pin package):
;
	#define LED_PORT PORTA
	#define LED_PIN 0
	#define BOOT_PORT PORTA
	#define NBOOT_PIN 5
#endif
;_______________________________________________________________
	radix dec			; Default base = 10 

 errorlevel-302				;avoid lots of warnings about banking

	CBLOCK 0x70
mscnt:	2
tstamp:	2
	ENDC

;**************************************************************
;	ORG 0x100
	ORG 0
resvect
	banksel	ANSELA
	goto	mainreset
	dw	0,0		;reserved for chksum calculation 
;				(only if ORG > 0, bootloader @0) 
	ORG resvect+4
;**********************************************************************************
;Interrupt service routine:
interrupt
	bcf	INTCON,TMR0IF
	movlw	6
	addwf	TMR0,F
	incfsz	mscnt,F
	retfie
	incf	mscnt+1,F
	retfie


mainreset
;(ANSELx bank selected, set used IOs to digital)
	bcf	LED_PORT,LED_PIN	;LED-Pin = digital I/O
	bcf	BOOT_PORT,NBOOT_PIN	;jump into bootloader if port=low

	banksel	OSCCON
	movlw	b'01111000'		;after reset, MPU is running on 500 kHz clock
	movwf	OSCCON			;set clock to 16MHz

	movlw	b'00000011'		;TMR0 @ 250kHz
	movwf	OPTION_REG
	
	bcf	LED_PORT,LED_PIN	;access to TRIS-register: LED-port = output

	banksel 0
	clrf	PORTA
	clrf	TMR0

	movlw	b'10100000'
	movwf	INTCON

	clrf	mscnt
	clrf	mscnt+1
	clrf	tstamp
	clrf	tstamp+1

mainloop
	btfss	BOOT_PORT,NBOOT_PIN	;jump into bootloader if port=low
	goto	bootloader

	bcf	INTCON,GIE
	movf	tstamp,W
	subwf	mscnt,W
	movf	tstamp+1,W
	subwfb	mscnt+1,W		;mscnt-tstamp
	bsf	INTCON,GIE
	btfsc	WREG,7			;timeout?
	goto	mainloop

	movlw	low 1000
	addwf	tstamp,F
	movlw	high 1000
	addwfc	tstamp+1,F		;next timeout after 1000ms

	movlw	1<<LED_PIN
	xorwf	LED_PORT,F		;toggle LED
	goto	mainloop


;detected low level at boot-pin: start into bootloader
bootloader
	clrf	INTCON			;disable all interrupts
	bsf	FSR0H,7			;notify bootloader about call from application
	goto	0			;here we go...


			
	END
