//*****************************************************************************
//*
//*		
//*		target.h
//*
//*
//*****************************************************************************
#ifndef 	__TARGET_H__
#define 	__TARGET_H__

#define MAXFLASHSIZE 0x10000
#define MAXROWSIZE 32			// max. flash erase block size (words)
#define BL_SUPPORT 1			// support of bootloader version up to this number	

typedef struct
{
	int app_start;				// begin of application program section
	int hardware_id;			// PIC's hardware ID word (type and revision)
	int hw_id;					// hardware ID, just PIC type, without revision
	int user_id;				// user-ID, packed into 16 bit
	char picname[20];			// pic device name
	int flashsize;				// flash memory size (words) of PIC
	int rowsize;				// PIC's erase block/row size (words)
	int eeaddr;					// location of data EEPROM
	int ee_size;				// size of EEPROM
	int bl_start, bl_end;		// bootloader section
	int rvsize;					// size of bl reset vector (1: goto, 2: movlp, goto) 
	int infsize;				// number of information words @start of bootloader code
	int patchcode;				// location for patch code (PICs reset vector) 
								// = last 8 words on top of bootloader section 
								// or 8 words before real bootloader code starts
	int xchk;					// exclude addr. >= xchk from checksum calculation
	int bl_version;				// bits 0-5: version number, bit 6: bl in upper memory
								// bit 7: bl uses checksum to validate application code
	int debugflag;				// (for testing)
} picdat_t;

typedef unsigned short int FLASH;
typedef unsigned char SFR;

int GetTargetInfo (void);
int CheckCompatibility(void);

extern FLASH picflash[MAXFLASHSIZE];
extern FLASH resetvect[2];
extern picdat_t picdata;

#endif 	


