// *****************************************************************************
// *
// *     target access
// *
// *****************************************************************************

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include <string.h>
#include "BLcom.h"
#include "target.h"

FLASH picflash[MAXFLASHSIZE];
FLASH resetvect[2] = {0,0};		//(for simulation only)
picdat_t picdata;
FILE *picdb;
char picname[20];  
extern char progname[];
extern char progpath[];

#define is_goto(opcode) ((opcode & 0x3800) == 0x2800)
#define is_bra(opcode) ((opcode & 0x3E00) == 0x3200)	
#define is_movlp(opcode) ((opcode  & 0x3F80) == 0x3180)
#define is_skipifnotwdto(opcode) (opcode == 0x1E03)

// *****************************************************************************
// try to set properties from PIC data file

void SetPICproperties(void)
{
	char string[256];
	char name[20];
	char c;
	int state=0, dev_id, mask, rowsize, flashsize, eesize, eeaddr;
	
	strcpy(string,progpath);
	strcat(string,".dat");

	picdb = fopen(string, "r");
	if(picdb == NULL)
	{
		picdb = fopen(string, "w");
		if(picdb != NULL)
		{
			fprintf(picdb, "* PIC data base for %s.exe\n",progname);
			fprintf(picdb, "*\n* Line format:\n");
			fprintf(picdb, "* <device name> <hardware ID> <mask hardware ID> <erase blk size> <prog flash size> <eeprom size> <eeprom addr>\n");
			fprintf(picdb, "* (all numbers: hexadecimal, size=words)\n");
			fprintf(picdb, "PIC12F1840 0x1B80 0x3FE0 0x0020 0x1000 0x100 0xF000\n");
			fprintf(picdb, "PIC12LF1840 0x1BC0 0x3FE0 0x0020 0x1000 0x100 0xF000\n");
			fprintf(picdb, "PIC16F1503 0x2CE0 0x3FE0 0x0010 0x0800 0 0\n");
			fprintf(picdb, "PIC16LF1503 0x2DA0 0x3FE0 0x0010 0x0800 0 0\n");
			fprintf(picdb, "PIC16F1705 0x3055 0x3FFF 0x0020 0x2000 0 0\n");
			fprintf(picdb, "PIC16LF1705 0x3057 0x3FFF 0x0020 0x2000 0 0\n");
			fprintf(picdb, "PIC16F1825 0x2760 0x3FE0 0x0020 0x2000 0x100 0xF000\n");
			fprintf(picdb, "PIC16LF1825 0x2860 0x3FE0 0x0020 0x2000 0x100 0xF000\n");
			fclose(picdb);
			printf("\nNew file (%s.dat) written\n",progname);
			picdb = fopen(string, "r");
		}
	}
	
	if (picdb != NULL)	
	{
		while ((c = fgetc(picdb)) != EOF)
		{
			while(isspace(c))
				c = fgetc(picdb);			// ignore spaces at start of line
			if(c == 'P')					// ignore line if it does not begin with 'P'
			{
				ungetc('P',picdb);
				if(((fscanf(picdb,"%20s %x %x %x %x %x %x", name, &dev_id, &mask, &rowsize, &flashsize, &eesize, &eeaddr)) == 7)
				&& (((picdata.hardware_id ^ dev_id) & mask) == 0))
				{
					picdata.hw_id = picdata.hardware_id & mask;		// ignore hw-revision number here
					strcpy(picdata.picname,name);
					picdata.flashsize = flashsize;	
					picdata.rowsize = rowsize;	
					picdata.eeaddr = eeaddr;
					picdata.ee_size = eesize;
					fclose(picdb);
					return;
				}
			}
			
			while((c = fgetc(picdb)) != '\n')	// ignore rest of line
				if(c == EOF) break;

		}
		fclose(picdb);
	}
}

// *****************************************************************************
// connect with bootloader and get infos about bootloader and PIC ID memory
// returns bl_version or -1 in case of no connection
//
// get bl_start address from instruction sequence (reset vector):
// Sequence A, used for bootloader in upper memory:
// 	   [movlp 	bootloader]		(optional: present if bl address > 0x800)
// 		goto	bootloder
//		
// Sequence B, used for bootloader @start of flash:
// 		btfss	STATUS,NOT_TO	;reset from watchdog timeout?
//		goto	application		;y: WDR handled by application
// 		goto	bootloader		;other resets: start into bootloader

int GetTargetInfo (void)
{
	int i, addr=0;
	int opcode;
	picdata.bl_start = 0;
//	int rvsize;
	
	resetvect[0] = picflash[0];		// (simulation)
	resetvect[1] = picflash[1];		

	if ((picdata.bl_version = connectBL()) < 0)
		return -1;					// no connection: abort! 	
	
	// analyze code at reset vector in order to get bootloader location
	// and location of patch memory:
	do {
		opcode = readMemWord (addr);			// read instruction code
		if(is_goto(opcode))					// instruction == "goto"?
		{
			picdata.bl_start |= opcode & 0x7FF;		// bl_start = operand from "goto"-instr.
			picdata.rvsize = addr+1;			// = 1 or 2, depending on location of goto-instr.
			break;								// (appears to be sequence A)
		}
		else if(is_skipifnotwdto(opcode))			// instruction == "btfss STATUS,NOT_TO"
		{
			picdata.app_start = readMemWord (addr+1) & 0x7FF;		// -> sequence B, get app_start from goto-instr.
			picdata.bl_end = picdata.app_start;				// bl section ends where applicaion starts
			break;
		}
		else if(is_movlp(opcode))			// movlp instruction?
		{
			picdata.bl_start = (opcode & 0x78) << 8;		// yes, set bits 11..14 of address, expect "goto"...
		}
			// skip other instructions, e.g. movlb, nop, ...
	} while (++addr < 4);

	if(picdata.bl_start & 0x3F00)						// bootloader in upper memory range
	{
		picdata.infsize = picdata.bl_start & 0x07;				// there might be a few words of info data
		picdata.app_start = 0;									// checksum calculation starts here
		opcode = readMemWord (picdata.bl_start+1);				// 2nd instruction = "goto patchcode" or "bra patchcode"
		if(is_skipifnotwdto(readMemWord (picdata.bl_start))		// first instruction of bootloader must be "btfss STATUS,NOT_TO"
		  && ((is_bra(opcode)) | (is_goto(opcode))))			// and second instr. must be goto or branch
		{
			if(is_bra(opcode))									// ("bra patchcode" is bootloader version >0)
			{
				if(opcode & 0x100)								// expand signed 9-bit branch arg.
					opcode = ~0xFF | (opcode & 0xFF);
				else
					opcode &= 0xFF;
				picdata.patchcode = (picdata.bl_start+2)+opcode;	// = destination address of branch
			}
			else
			{
				picdata.patchcode = (opcode & 0x7FF) | (picdata.bl_start & 0x7800); // bits 11..14 from "movlp"
																	// (bl-version 0 only)
			}
			if(picdata.patchcode > picdata.bl_start)		// if patchcode is located at end of bootloader code 
			{
				picdata.bl_end = picdata.patchcode+8;				// bl section ends after 8 words of patchcode 
				picdata.bl_start = picdata.bl_start/picdata.rowsize*picdata.rowsize;	// align to erase block
			}
			else
			{
				picdata.bl_start = picdata.patchcode;		// patchcode preceeds bootloader code
				if(picdata.infsize > 0)
				{
					opcode = readMemWord (picdata.bl_start+8);	// info about BL_END and rowsize
					picdata.rowsize = 1<<(opcode & 0x0F);
					picdata.bl_end = opcode & 0x3FF0;
				}
				else
					picdata.bl_end = 0;					// cannot determine bl_end: "not set"
			}
		}
		else
		{
			printf("\nunexpected opcode in bootloader!\n");
		}		
	}
	else
		picdata.bl_start = 0;						// bootloader located @start of flash
			
	for(i=0; i<4; i++)
	{
		picdata.user_id <<= 4;
		picdata.user_id |= readMemWord (0x8000+i) & 0x0F;	// user ID bits are 4 x 4 LSBs
	}
	picdata.hardware_id = picdata.hw_id = readMemWord (0x8006);
		
	if(picdata.bl_version <0)
		printf("\nlost connection!\n");
	else
		SetPICproperties();
	if(picdata.rowsize > MAXROWSIZE)
	{
		printf("\nunsupported rowsize!\n");
		exit(EXIT_FAILURE);
	}
	for(i=0; i<picdata.rowsize;i++)
	{
		picflash[0x8000+i] = readMemWord (0x8000+i) | 0x8000;
	}
	return picdata.bl_version;
}

// *****************************************************************************
// check bl version for compatibility
// returns -1 for no compatibility

int CheckCompatibility(void)
{
	char c;
	int timestamp = clock();

	if((picdata.bl_version & 0x3F) > BL_SUPPORT) 
	{
		printf("\nWARNING!\nTarget's bootloader version (%d) is higher than expected by %s!\n", picdata.bl_version & 0x3F, progname);
		printf("Please use an updated version of this program.\n");
		printf("You may use this version at your own risk, but be aware that it might\nprobably not work as expected!");
		printf("\n\nPress [Y] to go on with this version, [X] to abort:"); 
		while(1)
		{
			
			while(!kbhit())
			{
				keepAlive ();
				if((clock() - timestamp)/CLOCKS_PER_SEC > 40)
					return -1;				
			}
			c = toupper(getche());
			if(c=='X') return -1;
			if(c=='Y') return 0;
		}
	}
	else
		return 0;
}

