//*****************************************************************************
//*
//*
//*		hexread.cpp
//*
//*
//*****************************************************************************
//
#include <stdio.h>
#include <ctype.h>
#include "hexread.h"
#include "target.h"

FILE *source;
int checksum;

//***************************************************************************** 
// converts two ASCII hex characters from file (source), 
// accumulates data in checksum
// returns data if byte could be read from file, -1 otherwise  

int ascii2byte(void)
{
	int result=0, ch, i;
	
	for(i=0; i<2; i++)
	{
		result <<= 4;
		ch = toupper(fgetc(source));
		if (isxdigit(ch))
		{
			if (isdigit(ch))
				result |= ch-'0';
			else
				result |= ch + 10 -'A';
		}
		else 
			return -1;
	}
	
	checksum = (checksum + result) & 0xFF;
	return result;
}
	
//***************************************************************************** 
// reads hex file and fills "picflash" with it's data
// returns -1 on error, else returns address of used highest program memory 

int readHexFile(FILE *inputfile,FLASH *picflash, int flashsize)
{
	int maxprg = -1;
	int i, length, rectype, state=0;
	char idata;
	int xaddr=0,addr,data8, tempaddr;
	
	source = inputfile;
	
	while(1)
	{
		while((idata = fgetc(source)) != ':')			// ignore all before ':'
			if(idata == EOF) return 1;					// end of file - unexpected!
		checksum = 0;
			
		if((length = ascii2byte()) <0)
			return -1; 
			
		if((data8 = ascii2byte()) <0)
			return -1;
		if((addr = ascii2byte()) <0)
			return -1;
		addr |= (xaddr << 16) | (data8 << 8);
			
		if((rectype = ascii2byte()) <0)
			return -1;
			
		switch(rectype)
		{
		case 0:						// data record
			for(i=0;i<length;i++)
			{
				tempaddr = (addr+i)/2;		// hex file uses byte address, adress/2 = word address
				
				if(tempaddr >= MAXFLASHSIZE)
				{
					printf("\nHexfile contains invalid address!\n");
					return -1;
				}
				
				if((data8 = ascii2byte()) <0)
					return -1;
												
				if(xaddr==0)						// xaddr = 0: program data, >0: maybe config (i.e.user-ID) or EEPROM
				{
					// reject data which would overwrit bootloader code:
					if(((picdata.bl_start == 0) && (tempaddr < picdata.app_start))		// bootloader at bottom of flash
						|| (picdata.bl_start > 0 					// bootloader at higher address:
							&& tempaddr >= picdata.bl_start			// reject range bl_start..<bl_end,
							&& (tempaddr < picdata.bl_end || picdata.bl_end == 0)))		// above bootloader could be used for data storage
					{
						printf("\nData from Hexfile overwrite bootloader!\n");
						return -1;
					}

					if(((picdata.bl_start == 0) || (tempaddr < picdata.bl_start))	// if address is within program code section 
						&& (maxprg < tempaddr))						// && new maximum address:
						maxprg = tempaddr;							// adjust max. used program memory
						
					if(tempaddr >= flashsize)
					{
						printf("\nData from hexfile exceed flashsize!\n");
						return -1;
					}					
				}
				
				if ((addr+i) & 1)		// odd addresses are MSB
					picflash[tempaddr] = ((picflash[tempaddr] & 0xFF) | (data8 << 8)) & 0x3FFF;
				else
					picflash[tempaddr] = (picflash[tempaddr] & 0x3F00) | data8;
			}
			break;
		
		case 4:						// extended address
			if((data8 = ascii2byte()) <0)
				return -1;
			if((xaddr = ascii2byte()) <0)
				return -1;
			xaddr |= data8 << 8;
			break;
		
		case 1:						// end record
			break;
		}

		if(ascii2byte() <0)		// read checksum of record
			return -1;
		if(checksum)
			return -1;
			
		if(rectype == 1)		// if last record type == end
			break;				// exit from while-loop 
	}
	
	return maxprg;
}
