//*****************************************************************************
//*
//*
//*		Comport.cpp
//*
//*
//*****************************************************************************
//
//#define WIN32_LEAN_AND_MEAN
#include	<windows.h>
//#include	<memory.h>
#include	"Comport.h"

#ifdef		UNICODE
#define 	Z(a)		L##a
#else
#define 	Z(a)		a
#endif

//extern int writereturn;
static HANDLE	ComPortHandle;

//*****************************************************************************
//*
//*		ComOpen
//*
//*****************************************************************************
int ComOpen(int PortSelect,int Baud)
{
TCHAR				cName[]=Z("\\\\.\\COM11");
HANDLE				hFile;
COMMTIMEOUTS		sTo;
DCB					sDcb;

	if((PortSelect == 0) || (PortSelect > 99)) return 0;

	if(PortSelect<10)
	{
		cName[7]='0'+PortSelect;
		cName[8]=0;
	}
	else
	{
		cName[7]='0'+ PortSelect/10;
		cName[8]='0'+ PortSelect%10;
	}

	hFile= CreateFile(cName,GENERIC_READ|GENERIC_WRITE,0,0,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0);
	if(hFile==INVALID_HANDLE_VALUE)
	{
		hFile=0;
		return 0;
	}

	memset(&sDcb,0,sizeof(sDcb));
	
	sDcb.DCBlength=sizeof(sDcb);
	sDcb.BaudRate     	= Baud;
	sDcb.fParity      	= FALSE;
	sDcb.fBinary      	= TRUE;
	sDcb.Parity       	= NOPARITY;
	sDcb.StopBits     	= ONESTOPBIT;
	sDcb.fOutxCtsFlow 	= FALSE;
	sDcb.fOutxDsrFlow 	= FALSE;
	sDcb.fDtrControl	= DTR_CONTROL_DISABLE;
	sDcb.fRtsControl	= RTS_CONTROL_DISABLE;
	sDcb.fDsrSensitivity= FALSE;
	sDcb.fAbortOnError	= FALSE;
	sDcb.ByteSize     	= 8;
	

	if(!SetCommState(hFile,&sDcb))
	{
		CloseHandle(hFile);
		return 0;
	}


	sTo.ReadIntervalTimeout		   = MAXDWORD; 		// 0 ms Read-Timeout
	sTo.ReadTotalTimeoutMultiplier = 0;
	sTo.ReadTotalTimeoutConstant   = 0;
	sTo.WriteTotalTimeoutMultiplier= 0;
	sTo.WriteTotalTimeoutConstant  = 0;
	if(!SetCommTimeouts((HANDLE)hFile,&sTo))
	{
		CloseHandle(hFile);
		return 0;
	}


	ComPortHandle=hFile;
	return 1;
}



//*****************************************************************************
//*
//*		ComClose
//*
//*****************************************************************************
int	ComClose(void)
{

	CloseHandle(ComPortHandle);
	ComPortHandle=0;
	return 1;
}



//*****************************************************************************
//*
//*		ComRead
//*
//*****************************************************************************
int ComRead(void)
{
	unsigned char 	c;
	DWORD			dwCount;


	if(!ReadFile(ComPortHandle,&c,1,&dwCount,0))return -1;
	if(dwCount!=1)return -1;


	return c;
}

//*****************************************************************************
//*
//*		ComRead
//*
//*****************************************************************************
int ComRead(char *Buffer,int Max)
{
	DWORD	dwCount;
	ReadFile(ComPortHandle,Buffer,Max,&dwCount,0);
	return dwCount;
}


//*****************************************************************************
//*
//*		ComWrite
//*
//*****************************************************************************
int ComWrite(int Zeichen)
{
	DWORD			dwCount;
	WriteFile(ComPortHandle,&Zeichen,1,&dwCount,0);
	return dwCount;
}

//*****************************************************************************
//*
//*		ComWrite
//*
//*****************************************************************************
int	ComWrite(char *Buffer,int Count)
{
	DWORD			dwCount;

	WriteFile(ComPortHandle,Buffer,Count,&dwCount,0);
	return dwCount;
}



//*****************************************************************************
//*
//*		ComGetReadCount
//*
//*****************************************************************************
int ComGetReadCount(void)
{
	COMSTAT		sComStat;
	DWORD		dwErrorFlags;

	dwErrorFlags=0;
	if(!ClearCommError(ComPortHandle, &dwErrorFlags, &sComStat))return 0;
	return sComStat.cbInQue;
}

//*****************************************************************************
//*
//*		ComGetWriteCount
//*
//*****************************************************************************
int ComGetWriteCount(void)
{
COMSTAT		sComStat;
DWORD		dwErrorFlags;

	dwErrorFlags=0;
	if(!ClearCommError(ComPortHandle, &dwErrorFlags, &sComStat))return 0;
	return sComStat.cbOutQue;
}




